#!/bin/bash


while test $# -gt 0; do
 case "$1" in
 "-IP")
    IP="$2"
    shift;;
 "-PORT")
    PORT="$2"
    shift ;;
 "-PLAYER")
    PLAYER="$2"
    shift ;;
 "-RAM")
    RAM="$2"
    shift ;;
 "-ADDON")
    ADDON="$2"
    shift ;;
 "-LIMIT")
    LIMIT="$2"
    shift ;;
 "-RTKUSER")
    RTKUSER="$2"
    shift ;;
 "-PRIVATE")
    PRIVATE="$2"
    shift ;;
 esac
 shift
done

## kill den alten port =)
if [ ! -f minecraft_server.pid ]; then
  echo ""
else 
  pid=`cat minecraft_server.pid`
  kill -KILL $pid
  rm -rf minecraft_server.pid
fi

let REMOTE=${PORT}+1

## serversettings
grep server-ip= server.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i server.properties -e "s/^\(server-ip=\).*$/\1${IP}/"
else  # Nicht vorhanden!
  echo "server-ip=${IP}" >> server.properties
fi

grep server-port= server.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i server.properties -e "s/^\(server-port=\).*$/\1${PORT}/"
else  # Nicht vorhanden!
  echo "server-port=${PORT}" >> server.properties
fi

grep max-players= server.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i server.properties -e "s/^\(max-players=\).*$/\1${PLAYER}/"
else  # Nicht vorhanden!
  echo "max-players=${PLAYER}" >> server.properties
fi

grep enable-query= server.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i server.properties -e "s/^\(enable-query=\).*$/\1true/"
else  # Nicht vorhanden!
  echo "enable-query=true" >> server.properties
fi

grep query.port= server.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i server.properties -e "s/^\(query.port=\).*$/\1${PORT}/"
else  # Nicht vorhanden!
  echo "query.port=${PORT}" >> server.properties
fi

mkdir toolkit

grep maximum-heap-size= ./toolkit/wrapper.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i ./toolkit/wrapper.properties -e "s/^\(maximum-heap-size=\).*$/\1${RAM}M/"
else  # Nicht vorhanden!
  echo "maximum-heap-size=${RAM}M" >> ./toolkit/wrapper.properties
fi

grep initial-heap-size= ./toolkit/wrapper.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i ./toolkit/wrapper.properties -e "s/^\(initial-heap-size=\).*$/\1${RAM}M/"
else  # Nicht vorhanden!
  echo "initial-heap-size=${RAM}M" >> ./toolkit/wrapper.properties
fi

grep remote-bind-address= ./toolkit/remote.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i ./toolkit/remote.properties -e "s/^\(remote-bind-address=\).*$/\1${IP}/"
else  # Nicht vorhanden!
  echo "remote-bind-address=${IP}" >> ./toolkit/remote.properties
fi

grep remote-control-port= ./toolkit/remote.properties &>/dev/null
if [[ $? -eq 0 ]]; then  # Vorhanden!
  sed -i ./toolkit/remote.properties -e "s/^\(remote-control-port=\).*$/\1${REMOTE}/"
else  # Nicht vorhanden!
  echo "remote-control-port=${REMOTE}" >> ./toolkit/remote.properties
fi

if [ $PRIVATE == "true" ]; then
  echo Server startet im PRIVATEN modus. Bitte setzen sie Spieler auf die Whitelist um ihn benutzen zu koennen!
  grep white-list= server.properties &>/dev/null
  if [[ $? -eq 0 ]]; then  # Vorhanden!
    sed -i server.properties -e "s/^\(white-list=\).*$/\1true/"
  else  # Nicht vorhanden!
    echo "white-list=true" >> server.properties
  fi
else
echo Server Startet als Publicserver
fi

java -Xmx"$RAM"M -Xms"$RAM"M -jar minecraft_server.jar nogui $IP $PORT
fi

